<?php
header('Content-Type: application/xml; charset=UTF-8');
require_once(__DIR__ . '/../../app/includes/config.php');
require_once(__DIR__ . '/../../app/core/Database.php');

// Connect DB via framework connection class
$db = (new \Fir\Connection\Database())->connect();

// Pull recent unique locations from latest_searches joined to locations
// Fallback: if tables missing, output just the homepage
$urls = [];

$sql = "SELECT l.id, l.name, l.country, MAX(ls.id) AS last_id
        FROM latest_searches ls
        JOIN locations l ON l.id = ls.value
        GROUP BY l.id, l.name, l.country
        ORDER BY last_id DESC
        LIMIT 5000"; // keep sitemap reasonable

if ($result = $db->query($sql)) {
    while ($row = $result->fetch_assoc()) {
        $locUrl = URL_PATH . '/?location=' . urlencode($row['id']);
        $urls[] = $locUrl;
    }
    $result->free();
}

// If no URLs found, include homepage so the sitemap is valid
if (count($urls) === 0) {
    $urls[] = URL_PATH . '/';
}

echo "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n";
echo '<urlset xmlns="http://www.sitemaps.org/schemas/sitemap/0.9">';
foreach ($urls as $u) {
    echo '<url>';
    echo '<loc>'. htmlspecialchars($u, ENT_XML1) .'</loc>';
    echo '<changefreq>hourly</changefreq>';
    echo '<priority>0.8</priority>';
    echo '</url>';
}
echo '</urlset>';

$db->close();

