# Weather Data Feed Integration Plan

## Providers to evaluate
- OpenWeather One Call 3.0
- Tomorrow.io v4
- AerisWeather
- AccuWeather API
- Visual Crossing

### Required data
- Current: temp, humidity, wind speed/direction, summary, precipitation (rate/amount if available)
- Hourly: next 24–48h temperature, precip probability and amount, wind, humidity
- Daily: next 7–10 days highs/lows, precip probability and amount, wind, humidity

### Selection criteria
- Coverage/accuracy for Dharamshala region
- Latency and rate limits suitable for widget and site traffic
- License permitting caching (e.g., 10–30 minutes) and public redistribution
- Cost and clear attribution requirements

## Backend interface (proposed)

- PHP library wrapper in `app/libraries/Weather.php` with methods:
  - `getCurrent(float $lat, float $lon, string $units): array`
  - `getHourly(float $lat, float $lon, string $units, int $hours = 24): array`
  - `getDaily(float $lat, float $lon, string $units, int $days = 7): array`

- Caching: `file` or `redis` keyed by `lat:lon:units` with 10 min TTL for current/hourly and 30 min for daily.

## Public endpoints (examples)
- `GET /i.php?action=widget_current&lat=..&lon=..&units=metric|imperial`
  - Response JSON:
  ```json
  { "temperature": 17.2, "humidity": 62, "windSpeed": 12, "windDir": "NE", "summary": "Partly cloudy", "observedAt": 1730809200000 }
  ```
- `GET /i.php?action=forecast_hourly&lat=..&lon=..&hours=24&units=metric`
- `GET /i.php?action=forecast_daily&lat=..&lon=..&days=7&units=metric`

## Units and conversions
- Metric: Celsius, km/h, mm
- Imperial: Fahrenheit, mph, inches

## Error handling
- On provider failure, return last cached successful result with `cached: true` flag; otherwise fallback to minimal placeholders.

## Security
- Store provider API key in environment or `includes/config.php` and never expose client-side.

## Attribution
- Add provider-required attribution in footer and/or widget small-print if required by ToS.

